#version 400 compatibility

/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.com/copyright-license

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

/*DRAWBUFFERS:0*/
layout(location = 0) out vec4 sceneColor;

#include "/lib/head.glsl"
#include "/lib/util/colorspace.glsl"
#include "/lib/util/encoders.glsl"

in vec2 coord;

flat in mat2x3 lightColor;

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex2;
uniform sampler2D colortex3;

uniform sampler2D depthtex0;
uniform sampler2D depthtex1;

uniform sampler2D noisetex;

uniform int frameCounter;
uniform int isEyeInWater;

uniform float eyeAltitude;
uniform float far;
uniform float frameTimeCounter;

uniform vec2 taaOffset;
uniform vec2 viewSize;

uniform vec3 cameraPosition;

uniform mat4 gbufferModelView, gbufferModelViewInverse;
uniform mat4 gbufferProjection, gbufferProjectionInverse;

/* ------ includes ------ */
#define FUTIL_TBLEND
#include "/lib/fUtil.glsl"

#include "/lib/frag/bluenoise.glsl"
#include "/lib/frag/gradnoise.glsl"

#include "/lib/util/transforms.glsl"
#include "/lib/atmos/waterConst.glsl"

/* ------ simple fog ------ */

vec3 simpleFog(vec3 scenecolor, float d, vec3 color) {
    //float dist      = max(0.0, d-16.0);
    //float density   = (linStep(d, far * 0.4, far * 0.99));

    float dist      = max(0.0, d);
    float density   = 1.0-exp(-dist * 15e-3);
        density     = max(density, linStep(d, far * 0.4, far * 0.99));

    return mix(scenecolor, color, density);
}

vec3 lavaFog(vec3 scene, float d) {
    float density   = max(0.0, d);

    float transmittance = expf(-1.0 * density);

    return mix(vec3(1.0, 0.3, 0.02), scene, transmittance);
}

/* ------ reflections ------ */
#define noBRDF
#include "/lib/light/brdf.glsl"

#include "/lib/frag/labPBR.glsl"

#include "/lib/frag/ssr.glsl"

/*
These two functions used for rough reflections are based on zombye's spectrum shaders
https://github.com/zombye/spectrum
*/

mat3 getRotationMat(vec3 x, vec3 y) {
	float cosine = dot(x, y);
	vec3 axis = cross(y, x);

	float tmp = 1.0 / dot(axis, axis);
	      tmp = tmp - tmp * cosine;
	vec3 tmpv = axis * tmp;

	return mat3(
		axis.x * tmpv.x + cosine, axis.x * tmpv.y - axis.z, axis.x * tmpv.z + axis.y,
		axis.y * tmpv.x + axis.z, axis.y * tmpv.y + cosine, axis.y * tmpv.z - axis.x,
		axis.z * tmpv.x - axis.y, axis.z * tmpv.y + axis.x, axis.z * tmpv.z + cosine
	);
}
vec3 ggxFacetDist(vec3 viewDir, float roughness, vec2 xy) {
	/*
    GGX VNDF sampling
	http://www.jcgt.org/published/0007/04/01/
    */

    viewDir     = normalize(vec3(roughness * viewDir.xy, viewDir.z));

    float clsq  = dot(viewDir.xy, viewDir.xy);
    vec3 T1     = vec3(clsq > 0.0 ? vec2(-viewDir.y, viewDir.x) * inversesqrt(clsq) : vec2(1.0, 0.0), 0.0);
    vec3 T2     = vec3(-T1.y * viewDir.z, viewDir.z * T1.x, viewDir.x * T1.y - T1.x * viewDir.y);

	float r     = sqrt(xy.x);
	float phi   = tau * xy.y;
	float t1    = r * cos(phi);
	float a     = saturate(1.0 - t1 * t1);
	float t2    = mix(sqrt(a), r * sin(phi), 0.5 + 0.5 * viewDir.z);

	vec3 normalH = t1 * T1 + t2 * T2 + sqrt(saturate(a - t2 * t2)) * viewDir;

	return normalize(vec3(roughness * normalH.xy, normalH.z));
}

void main() {
    sceneColor       = stex(colortex0);  //that macro certainly makes it neater
    vec4 tex1       = stex(colortex1);
    vec4 tex2       = stex(colortex2);
    vec4 tex3       = stex(colortex3);

    vec3 sceneNormal = decodeNormal(tex1.xy);
    vec3 viewNormal = normalize(mat3(gbufferModelView) * sceneNormal);

    float sceneDepth0   = stex(depthtex0).x;
    vec3 viewPos0       = screenToViewSpace(vec3(coord, sceneDepth0));
    vec3 scenePos0      = viewToSceneSpace(viewPos0);

    float sceneDepth1   = stex(depthtex1).x;
    vec3 viewPos1       = screenToViewSpace(vec3(coord, sceneDepth1));
    vec3 scenePos1      = viewToSceneSpace(viewPos1);

    bool translucent    = (sceneDepth0<sceneDepth1);

    vec3 translucentAlbedo = sqr(decode3x8(tex2.z));

    sceneColor.rgb      = blendTranslucencies(sceneColor.rgb, tex3, translucentAlbedo);

    materialProperties material = materialProperties(0.0001, 0.02, false, false, mat2x3(1.0));
        material        = decodeLabBasic(decode2x8(tex2.y));

    float bluenoise     = ditherBluenoise();


    /* ------ reflections ------ */
    
    #ifdef resourcepackReflectionsEnabled

    if (material.roughness < 0.95){
        vec3 viewDir    = normalize(viewPos0);

        vec4 reflection = vec4(0.0);

        vec3 metalAlbedo = translucentAlbedo;

        vec3 fresnel    = vec3(0.0);

        #ifdef roughReflectionsEnabled

        if (material.roughness < 0.0002) {
            vec3 reflectDir = reflect(viewDir, viewNormal);

            if (dot(viewDir, viewNormal) > 0.0) viewNormal = -viewNormal;

            vec3 viewNormalSSR  = viewNormal;

            if (dot(viewDir, viewNormalSSR) > 0.0) viewNormalSSR = -viewNormalSSR;

            reflection          = screenRT(viewPos0, viewNormalSSR, bluenoise, translucent);

            fresnel   = BRDFfresnel(-viewDir, viewNormal, material, metalAlbedo);
        } else {
            float ssrAlpha  = 1.0 - sstep(material.roughness, roughSSR_maxR - 0.05, roughSSR_maxR);
            
            mat3 rot    = getRotationMat(vec3(0, 0, 1), viewNormal);
            vec3 tangentV = viewDir * rot;
            float noise = bluenoise;
            float dither = ditherGradNoiseTemporal();

            const uint steps    = roughReflectionSamples;
            const float rSteps  = 1.0 / float(steps);

            for (uint i = 0; i < steps; ++i) {
                vec2 xy         = vec2(fract((i + noise) * sqr(32.0) * phi), (i + noise) * rSteps);
                vec3 roughNrm   = rot * ggxFacetDist(-tangentV, material.roughness, xy);

                if (dot(viewDir, roughNrm) > 0.0) roughNrm = -roughNrm;

                vec3 reflectDir = reflect(viewDir, roughNrm);

                vec3 viewNormalSSR  = roughNrm;

                if (dot(viewDir, viewNormalSSR) > 0.0) viewNormalSSR = -viewNormalSSR;

                vec4 currReflection     = vec4(0.0);

                if (ssrAlpha > 0.0) currReflection = screenRT_Fast(viewPos0, viewNormalSSR, dither, translucent);

                if (currReflection.a < 0.5) {
                    currReflection      = vec4(lightColor[0] / tau, 1.0);
                }

                reflection += currReflection;
                fresnel    += BRDFfresnel(-viewDir, roughNrm, material, metalAlbedo);
            }
            reflection *= rSteps;
            fresnel    *= rSteps;
            reflection.a *= 1.0 - linStep(material.roughness, roughReflectionsThreshold * 0.66, roughReflectionsThreshold);
        }

        #else

            vec3 reflectDir = reflect(viewDir, viewNormal);

            vec3 viewNormalSSR  = viewNormal;

            if (dot(viewDir, viewNormalSSR) > 0.0) viewNormalSSR = -viewNormalSSR;

            reflection          = screenRT(viewPos0, viewNormalSSR, bluenoise, translucent);

            if (reflection.a < 0.5) {
                reflection      = vec4(lightColor[0] / tau, 1.0);
            }

            reflection.a *= 1.0 - linStep(material.roughness, roughReflectionsThreshold * 0.66, roughReflectionsThreshold);

            fresnel   = BRDFfresnel(-viewDir, viewNormal, material, metalAlbedo);

        #endif
        
        //vec3 fresnel   = BRDFfresnel(-viewDir, viewNormal, material, metalAlbedo);

        if (material.conductor && material.conductorComplex) reflection.rgb *= sqrt(metalAlbedo);
        
        if (material.conductor) {
            float diffuseLum    = getLuma(sceneColor.rgb);
            float reflectionLum = getLuma(reflection.rgb * fresnel);

            float darknessComp  = saturate(-(reflectionLum - diffuseLum / tau) / max(diffuseLum, reflectionLum));
                darknessComp   *= 0.2;

            sceneColor.rgb = mix(sceneColor.rgb, reflection.rgb * fresnel + sceneColor.rgb * darknessComp, reflection.a);
        }
        else sceneColor.rgb = mix(sceneColor.rgb, reflection.rgb, vec3(reflection.a) * fresnel);

        #if DEBUG_VIEW == 6
            sceneColor.rgb = reflection.rgb;
        #endif
    }
    #endif

    sceneColor.rgb      = simpleFog(sceneColor.rgb, length(scenePos0), lightColor[0] / tau);

    if (isEyeInWater == 2) {
        sceneColor.rgb = lavaFog(sceneColor.rgb, length(viewPos0));
    }

    sceneColor      = makeDrawbuffer(sceneColor);
}